<?php
	$video = $fields['field_home_video']->content;
	$src = explode("/", $video);
	$end = end($src);
?>

<div class="videoPlayer" id="videoContainer">
	<video id="video" muted autoplay loop>
		<source src="/sites/capereamol.com/files/CapeReamolMauritius.mp4" type="video/mp4">
	</video>
	<div id="video-controls">
		<img id="play-pause" src="/sites/all/themes/capereamol/css/img/icon-play.svg"/>
		<img id="mute" src="/sites/all/themes/capereamol/css/img/icon-volume-mute.svg"/>
	</div>
</div>
<script>
window.onload = function() {

  // Video
  var video = document.getElementById("video");

  // Buttons
  var playButton = document.getElementById("play-pause");
  var muteButton = document.getElementById("mute");

  // Sliders
  var seekBar = document.getElementById("seek-bar");
  var volumeBar = document.getElementById("volume-bar");

// Event listener for the play/pause button
playButton.addEventListener("click", function() {
  if (video.paused == true) {
    // Play the video
    video.play();

    // Update the button text to 'Pause'
    playButton.src = "/sites/all/themes/capereamol/css/img/icon-pause.svg";
  } else {
    // Pause the video
    video.pause();

    // Update the button text to 'Play'
    playButton.src = "/sites/all/themes/capereamol/css/img/icon-play.svg";
  }
});

// Event listener for the mute button
muteButton.addEventListener("click", function() {
  if (video.muted == false) {
    // Mute the video
    video.muted = true;

    // Update the button text
    muteButton.src = "/sites/all/themes/capereamol/css/img/icon-volume-mute.svg";
  } else {
    // Unmute the video
    video.muted = false;

    // Update the button text
    muteButton.src = "/sites/all/themes/capereamol/css/img/icon-volume-sound.svg";
  }
});

}
</script>