function SendContactForm(email, name, message)
{
	if(!ValidateForm(email, name, message))
	{
		alert('Please correct the contact form');
		return false;
	}
	else
	{
	    const name = jQuery('#fieldName').val();
	    const email = jQuery('#fieldEmail').val();
	    const message = jQuery('#fieldMessage').val();
	    const html_message = 'Name: ' + name + '<br>' +
            'Email: ' + email + '<br>' +
            'Message: ' + message;

 		jQuery.loader({ className:"blue-with-image-2", content:'' });
        send(name + ' - CapeReamol - contact form', html_message, 'info@capereamol.com' 'www.CapeReamol.com<formularz@post.pl>');
        // send(name + ' - CapeReamol - contact form', html_message, 'sylwester@labmatic.com', 'www.CapeReamol.com<formularz@post.pl>');

		// jQuery.ajax({
		// 	url: '/mailing/send.php',
		// 	type: 'post',
		// 	data: {
		// 		name: name,
		// 		email: email,
		// 		message: message
		// 	},
		// 	async:false,
		// 	success: function(output){
		// 		jQuery.loader('close');
		// 		alert('Message was sent successfully.');
		// 		ClearFields();
		// 	},
		// 	error: function(output){
		// 		jQuery.loader('close');
		// 		alert('Some errors occurred, please try again later.');
		// 	}
		// });
	}
}

function ValidateForm(email, name, message)
{
	var validationResult=true;
	var okColor='#ffffff';
	var errColor='#FF4F04';
	if(name.length < 2)
	{
		ChagneBorderColor('fieldName', errColor);
		validationResult=false;
	}
	else
		ChagneBorderColor('fieldName', okColor)
	if(!ValidateEmail(email))
	{
		ChagneBorderColor('fieldEmail', errColor);
		validationResult=false;
	}
	else
		ChagneBorderColor('fieldEmail', okColor)
	if(message.length < 5)
	{
		ChagneBorderColor('fieldMessage', errColor);
		validationResult=false;
	}
	else
		ChagneBorderColor('fieldMessage', okColor)
	return validationResult;
}
/* ^^ contact form --------------------------------------- */

/* -- dealer form ---------------------------------------- */
function SendDealerForm(fields)
{
	if(!ValidateDealerForm(fields))
	{
		alert('Please correct the contact form');
		return false;
	}
	else
	{
		jQuery.loader({ className:"blue-with-image-2", content:'' });
		jQuery.ajax({
			url: '/mailing/send.php?d=dealer',
			type: 'post',
			data: {
				company: fields[0].value,
				person: fields[1].value,
				phone: fields[2].value,
				address: fields[3].value,
				email: fields[4].value,
				www: fields[5].value,
				business: GetBusinessType(fields),
				question: fields[10].value
			},
			async:false,
			success: function(output){
				jQuery.loader('close');
				alert('Message was sent successfully.');
				ClearFields();
			},
			error: function(output){
				jQuery.loader('close');
				alert('Some errors occurred, please try again later.');
			}
		});
	}
}

function GetBusinessType(fields)
{
	var myBusiness='';
	for(var i=6; i<10; i++)
	{
		if(fields[i].checked)
			myBusiness=myBusiness+fields[i].value+', ';
	}
	return myBusiness;
}

function ValidateDealerForm(fields)
{
	var validationResult=true;
	var errColor='#FF4F03';
	var okColor='#000';
	var chBox=false;
	for(var i=0; i<fields.length; i++)
	{
		if( fields[i].id=='email' )
		{
			if(!ValidateEmail(fields[i].value))
			{
				ChagneBorderColor(fields[i].id, errColor);
				validationResult=false;
			}
			else
				ChagneBorderColor(fields[i].id, okColor);
		}
		else
		{
			if( fields[i].value.length < 2 )
			{
				ChagneBorderColor(fields[i].id, errColor);
				validationResult=false;
			}
			else
				ChagneBorderColor(fields[i].id, okColor)
		}
		if(fields[i].type == 'checkbox' && fields[i].checked)
			chBox=true;
	}
	if(!chBox)
	{
		ChagneBorderColor('myBusiness', errColor);
		validationResult=false;
	}
	else
		ChagneBorderColor('myBusiness', '#fff');

	return validationResult;
}
/* ^^ dealer form ---------------------------------------- */

/* ------------------------------------------------------- */
function ValidateEmail(email)
{
	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	return re.test(email);
}

function ChagneBorderColor(eleId, color)
{
	jQuery('#'+eleId).css('border-color', color);
}

function ClearFields()
{
	document.getElementById('fieldEmail').value='';
	document.getElementById('fieldName').value='';
	document.getElementById('fieldMessage').value='';
}

/* -- document ready ----------------------------------- */
jQuery(document).ready(function(){
	if(jQuery('#dealerContactForm button').length > 0)
	{
		jQuery('#dealerContactForm button').click(function(){
			SendDealerForm(jQuery('#dealerContactForm .formField'));
		});
	}
});