<?php 
	drupal_add_js('http://maps.googleapis.com/maps/api/js?sensor=false', 'external');
	$coordinates=GetCoordinates(trim(strip_tags($rows)));
?>
<div id="googlemapsContainer">
	<div id="map-canvas"></div>	
</div>

<?php
	function GetCoordinates($coord)
	{
		$coordArray=array();
		$beginTag='POINT(';
		$endTag=')';
		$begin=$end=$offset=0;
		$i=0;
		while($i++ < 20)
		{
			$begin=strpos($coord, $beginTag, $offset);
			if(!is_numeric($begin))
				break;
			$end=strpos($coord, $endTag, $offset);			
			$coordArray[]=explode(' ', substr($coord, $begin+strlen($beginTag), $end-($begin+strlen($beginTag))));
			$offset=$end+strlen($endTag)+2;
		}
		return $coordArray;
	}
	
	function PrintPlaces($x)
	{
		foreach($x as $y)
		{
			print "['',".$y[1].",".$y[0].",13],";;
		}
	}
?>
<script>
	//-- google maps
	var places=[<?php print PrintPlaces($coordinates);?>];
	var map;
	function initialize() {
		var mapOptions = {
			zoom: 14,
			center: new google.maps.LatLng(52.2991736248, 18.7327790167)
		}
		map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
		setMarkers(map, places);	  
	}
	google.maps.event.addDomListener(window, 'load', initialize);
	//-- google maps

	function setMarkers(map, locations)
	{
		var imgMarker = {
			url: '/sites/all/themes/capereamol/css/img/flag1.png',		
			size: new google.maps.Size(32, 48),		
			origin: new google.maps.Point(0,0),
			anchor: new google.maps.Point(16,48)
		}; 
		var shape = {
			coord: [1, 1, 1, 40, 40, 40, 40 , 1],
			type: 'poly'
		};  
		var markerBounds = new google.maps.LatLngBounds();
    
		for (var i = 0; i < locations.length; i++)
		{		
			var beach = locations[i];			
			var myLatLng = new google.maps.LatLng(beach[1], beach[2]);
			var marker = new google.maps.Marker({
				position: myLatLng,
				map: map,
				icon: imgMarker,
				shape: shape,
				title: beach[0],
				zIndex: beach[3]
			});
			markerBounds.extend(myLatLng);
		}  
		map.fitBounds(markerBounds);
	}
	
	function ParseCoord(coord)
	{
		var spacepos=coord.indexOf(' ');
		var coordArr=[];
		coordArr.push(parseFloat((coord.substr(6, spacepos-6))));
		coordArr.push(parseFloat((coord.substr(spacepos+1, coord.length-spacepos-2))));
		return coordArr;
	}
	
	jQuery(document).ready(function(){
		jQuery('.seeonmap').click(function(){			
			var coordArr=ParseCoord(jQuery(this).attr('coord'));
			var ss=new google.maps.LatLng(coordArr[1], coordArr[0], true);
			map.panTo(ss);
			map.setZoom(16);
			jQuery('html, body').animate( {scrollTop: 0}, 500);
		});
	});
</script>